/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.filter.mongo;

import java.util.List;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.filter.Filter;
import me.lucko.luckperms.common.filter.FilterField;
import me.lucko.luckperms.common.filter.FilterList;
import me.lucko.luckperms.common.filter.mongo.ConstraintMongoBuilder;
import me.lucko.luckperms.lib.bson.conversions.Bson;
import me.lucko.luckperms.lib.mongodb.client.model.Filters;

public abstract class FilterMongoBuilder<T>
extends ConstraintMongoBuilder {
    public abstract String mapFieldName(FilterField<T, ?> var1);

    public Bson make(Filter<T, ?> filter) {
        return this.make(filter.constraint(), this.mapFieldName(filter.field()));
    }

    public Bson make(FilterList.LogicalOperator combineOperator, List<? extends Filter<T, ?>> filters) {
        if (filters.isEmpty()) {
            return Filters.empty();
        }
        List bsonFilters = filters.stream().map(this::make).collect(Collectors.toList());
        switch (combineOperator) {
            case AND: {
                return Filters.and(bsonFilters);
            }
            case OR: {
                return Filters.or(bsonFilters);
            }
        }
        throw new AssertionError((Object)combineOperator);
    }

    public Bson make(FilterList<T> filters) {
        return this.make(filters.operator(), (List<? extends Filter<T, ?>>)((Object)filters));
    }
}

