/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.filter.sql;

import me.lucko.luckperms.common.filter.Comparison;
import me.lucko.luckperms.common.filter.Constraint;
import me.lucko.luckperms.common.filter.PageParameters;
import me.lucko.luckperms.common.storage.implementation.sql.builder.AbstractSqlBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConstraintSqlBuilder
extends AbstractSqlBuilder {
    public void visitConstraintValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Don't know how to write value with type: " + value.getClass().getName());
        }
        this.builder.variable((String)value);
    }

    public void visit(Constraint<?> constraint) {
        this.visit(constraint.comparison());
        this.builder.append(' ');
        this.visitConstraintValue(constraint.value());
    }

    public void visit(Comparison comparison) {
        switch (comparison) {
            case EQUAL: {
                this.builder.append("=");
                break;
            }
            case NOT_EQUAL: {
                this.builder.append("!=");
                break;
            }
            case SIMILAR: {
                this.builder.append("LIKE");
                break;
            }
            case NOT_SIMILAR: {
                this.builder.append("NOT LIKE");
                break;
            }
            default: {
                throw new AssertionError((Object)comparison);
            }
        }
    }

    public void visit(@Nullable PageParameters params) {
        if (params == null) {
            return;
        }
        int pageSize = params.pageSize();
        int pageNumber = params.pageNumber();
        this.builder.append(" LIMIT " + pageSize + " OFFSET " + (pageNumber - 1) * pageSize);
    }
}

