/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.http;

import java.io.IOException;
import java.util.Objects;
import me.lucko.luckperms.common.http.AbstractHttpClient;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.lib.okhttp3.OkHttpClient;
import me.lucko.luckperms.lib.okhttp3.Request;
import me.lucko.luckperms.lib.okhttp3.Response;
import me.lucko.luckperms.lib.okhttp3.WebSocket;
import me.lucko.luckperms.lib.okhttp3.WebSocketListener;

public class BytesocksClient
extends AbstractHttpClient {
    private final String httpUrl;
    private final String wsUrl;
    private final String userAgent;

    public BytesocksClient(OkHttpClient okHttpClient, String host, boolean tls, String userAgent) {
        super(okHttpClient);
        this.httpUrl = (tls ? "https://" : "http://") + host + "/";
        this.wsUrl = (tls ? "wss://" : "ws://") + host + "/";
        this.userAgent = userAgent;
    }

    public Socket createSocket(WebSocketListener listener) throws IOException, UnsuccessfulRequestException {
        String id;
        Request createRequest = new Request.Builder().url(this.httpUrl + "create").header("User-Agent", this.userAgent).build();
        try (Response response = this.makeHttpRequest(createRequest);){
            if (response.code() != 201) {
                throw new UnsuccessfulRequestException(response);
            }
            id = Objects.requireNonNull(response.header("Location"));
        }
        Request socketRequest = new Request.Builder().url(this.wsUrl + id).header("User-Agent", this.userAgent).build();
        return new Socket(id, this.okHttp.newWebSocket(socketRequest, listener));
    }

    public static final class Socket {
        private final String channelId;
        private final WebSocket socket;

        public Socket(String channelId, WebSocket socket) {
            this.channelId = channelId;
            this.socket = socket;
        }

        public String channelId() {
            return this.channelId;
        }

        public WebSocket socket() {
            return this.socket;
        }
    }
}

