/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.locale;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.MoreFiles;
import me.lucko.luckperms.lib.adventure.key.Key;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.translation.GlobalTranslator;
import me.lucko.luckperms.lib.adventure.translation.TranslationRegistry;
import me.lucko.luckperms.lib.adventure.translation.Translator;
import me.lucko.luckperms.lib.adventure.util.UTF8ResourceBundleControl;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslationManager {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final LuckPermsPlugin plugin;
    private final Set<Locale> installed = ConcurrentHashMap.newKeySet();
    private TranslationRegistry registry;
    private final Path translationsDirectory;
    private final Path repositoryTranslationsDirectory;
    private final Path customTranslationsDirectory;

    public TranslationManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        this.translationsDirectory = this.plugin.getBootstrap().getConfigDirectory().resolve("translations");
        this.repositoryTranslationsDirectory = this.translationsDirectory.resolve("repository");
        this.customTranslationsDirectory = this.translationsDirectory.resolve("custom");
        try {
            MoreFiles.createDirectoriesIfNotExists(this.repositoryTranslationsDirectory);
            MoreFiles.createDirectoriesIfNotExists(this.customTranslationsDirectory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Path getTranslationsDirectory() {
        return this.translationsDirectory;
    }

    public Path getRepositoryTranslationsDirectory() {
        return this.repositoryTranslationsDirectory;
    }

    public Path getRepositoryStatusFile() {
        return this.repositoryTranslationsDirectory.resolve("status.json");
    }

    public Set<Locale> getInstalledLocales() {
        return Collections.unmodifiableSet(this.installed);
    }

    public void reload() {
        if (this.registry != null) {
            GlobalTranslator.translator().removeSource((Translator)this.registry);
            this.installed.clear();
        }
        this.registry = TranslationRegistry.create((Key)Key.key((String)"luckperms", (String)"main"));
        this.registry.defaultLocale(DEFAULT_LOCALE);
        this.loadFromFileSystem(this.customTranslationsDirectory, false);
        this.loadFromFileSystem(this.repositoryTranslationsDirectory, true);
        this.loadFromResourceBundle();
        GlobalTranslator.translator().addSource((Translator)this.registry);
    }

    private void loadFromResourceBundle() {
        block2: {
            ResourceBundle bundle = ResourceBundle.getBundle("luckperms", DEFAULT_LOCALE, UTF8ResourceBundleControl.get());
            try {
                this.registry.registerAll(DEFAULT_LOCALE, bundle, false);
            }
            catch (IllegalArgumentException e) {
                if (TranslationManager.isAdventureDuplicatesException(e)) break block2;
                this.plugin.getLogger().warn("Error loading default locale file", e);
            }
        }
    }

    public static boolean isTranslationFile(Path path) {
        return path.getFileName().toString().endsWith(".properties");
    }

    public void loadFromFileSystem(Path directory, boolean suppressDuplicatesError) {
        List<Path> translationFiles;
        try (Stream<Path> stream = Files.list(directory);){
            translationFiles = stream.filter(TranslationManager::isTranslationFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            translationFiles = Collections.emptyList();
        }
        if (translationFiles.isEmpty()) {
            return;
        }
        HashMap<Locale, ResourceBundle> loaded = new HashMap<Locale, ResourceBundle>();
        for (Path translationFile : translationFiles) {
            try {
                Map.Entry<Locale, ResourceBundle> result = this.loadTranslationFile(translationFile);
                loaded.put(result.getKey(), result.getValue());
            }
            catch (Exception e) {
                if (suppressDuplicatesError && TranslationManager.isAdventureDuplicatesException(e)) continue;
                this.plugin.getLogger().warn("Error loading locale file: " + String.valueOf(translationFile.getFileName()), e);
            }
        }
        loaded.forEach((locale, bundle) -> {
            Locale localeWithoutCountry = new Locale(locale.getLanguage());
            if (!locale.equals(localeWithoutCountry) && !localeWithoutCountry.equals(DEFAULT_LOCALE) && this.installed.add(localeWithoutCountry)) {
                try {
                    this.registry.registerAll(localeWithoutCountry, bundle, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    private Map.Entry<Locale, ResourceBundle> loadTranslationFile(Path translationFile) throws IOException {
        PropertyResourceBundle bundle;
        String fileName = translationFile.getFileName().toString();
        String localeString = fileName.substring(0, fileName.length() - ".properties".length());
        Locale locale = TranslationManager.parseLocale(localeString);
        if (locale == null) {
            throw new IllegalStateException("Unknown locale '" + localeString + "' - unable to register.");
        }
        try (BufferedReader reader = Files.newBufferedReader(translationFile, StandardCharsets.UTF_8);){
            bundle = new PropertyResourceBundle(reader);
        }
        this.registry.registerAll(locale, (ResourceBundle)bundle, false);
        this.installed.add(locale);
        return Maps.immutableEntry((Object)locale, (Object)bundle);
    }

    private static boolean isAdventureDuplicatesException(Exception e) {
        return e instanceof IllegalArgumentException && (e.getMessage().startsWith("Invalid key") || e.getMessage().startsWith("Translation already exists"));
    }

    public static Component render(Component component) {
        return TranslationManager.render(component, Locale.getDefault());
    }

    public static Component render(Component component, @Nullable String locale) {
        return TranslationManager.render(component, TranslationManager.parseLocale(locale));
    }

    public static Component render(Component component, @Nullable Locale locale) {
        if (locale == null && (locale = Locale.getDefault()) == null) {
            locale = DEFAULT_LOCALE;
        }
        return GlobalTranslator.render((Component)component, (Locale)locale);
    }

    public static @Nullable Locale parseLocale(@Nullable String locale) {
        return locale == null ? null : Translator.parseLocale((String)locale);
    }

    public static String localeDisplayName(Locale locale) {
        if (locale.getLanguage().equals("zh")) {
            if (locale.getCountry().equals("CN")) {
                return "\u7b80\u4f53\u4e2d\u6587";
            }
            if (locale.getCountry().equals("TW")) {
                return "\u7e41\u9ad4\u4e2d\u6587";
            }
            return locale.getDisplayCountry(locale) + locale.getDisplayLanguage(locale);
        }
        if (locale.getLanguage().equals("en") && locale.getCountry().equals("PT")) {
            return "Pirate";
        }
        return locale.getDisplayLanguage(locale);
    }
}

