/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UserIdentifier {
    private final UUID uniqueId;
    private final String username;

    public static UserIdentifier of(@NonNull UUID uniqueId, @Nullable String username) {
        Objects.requireNonNull(uniqueId, "uuid");
        if (username == null || username.equalsIgnoreCase("null") || username.isEmpty()) {
            username = null;
        }
        return new UserIdentifier(uniqueId, username);
    }

    private UserIdentifier(UUID uniqueId, String username) {
        this.uniqueId = uniqueId;
        this.username = username;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserIdentifier)) {
            return false;
        }
        UserIdentifier other = (UserIdentifier)o;
        return this.uniqueId.equals(other.uniqueId);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return "UserIdentifier(uniqueId=" + String.valueOf(this.uniqueId) + ", username=" + this.username + ")";
    }
}

