/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Locale;
import java.util.Map;
import me.lucko.luckperms.common.cache.Cache;
import me.lucko.luckperms.common.cacheddata.result.IntegerResult;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.WeightNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WeightCache
extends Cache<IntegerResult<WeightNode>> {
    private final Group group;

    public WeightCache(Group group) {
        this.group = group;
    }

    @Override
    protected @NonNull IntegerResult<WeightNode> supply() {
        Map<String, Integer> configWeights;
        Integer value;
        IntegerResult<WeightNode> weight = null;
        for (WeightNode n : this.group.getOwnNodes(NodeType.WEIGHT, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL)) {
            int value2 = n.getWeight();
            if (weight != null && value2 <= weight.intResult()) continue;
            weight = IntegerResult.of(n);
        }
        if (weight == null && (value = (configWeights = this.group.getPlugin().getConfiguration().get(ConfigKeys.GROUP_WEIGHTS)).get(this.group.getIdentifier().getName().toLowerCase(Locale.ROOT))) != null) {
            weight = IntegerResult.of(value);
        }
        return weight != null ? weight : IntegerResult.nullResult();
    }
}

