/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model.nodemap;

import java.util.Iterator;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.comparator.ContextSetComparator;
import me.lucko.luckperms.common.model.InheritanceOrigin;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.nodemap.NodeMapBase;
import me.lucko.luckperms.common.node.comparator.NodeComparator;
import me.lucko.luckperms.common.util.Difference;
import net.luckperms.api.context.ContextSatisfyMode;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.metadata.types.InheritanceOriginMetadata;
import net.luckperms.api.node.types.InheritanceNode;

public class NodeMapMutable
extends NodeMapBase {
    private static final Function<ImmutableContextSet, SortedSet<Node>> VALUE_SET_SUPPLIER = k -> new ConcurrentSkipListSet<Node>(NodeComparator.reverse());
    private static final Function<ImmutableContextSet, SortedSet<InheritanceNode>> INHERITANCE_VALUE_SET_SUPPLIER = k -> new ConcurrentSkipListSet<Node>(NodeComparator.reverse());
    private SortedMap<ImmutableContextSet, SortedSet<Node>> map = NodeMapMutable.createMap();
    private SortedMap<ImmutableContextSet, SortedSet<InheritanceNode>> inheritanceMap = NodeMapMutable.createMap();
    private final Lock lock = new ReentrantLock();
    protected final PermissionHolder holder;
    private final InheritanceOrigin inheritanceOrigin;

    private static <N extends Node> SortedMap<ImmutableContextSet, SortedSet<N>> createMap() {
        return new ConcurrentSkipListMap<ImmutableContextSet, SortedSet<N>>(ContextSetComparator.reverse());
    }

    public NodeMapMutable(PermissionHolder holder, DataType type) {
        this.holder = holder;
        this.inheritanceOrigin = new InheritanceOrigin(holder.getIdentifier(), type);
    }

    @Override
    protected SortedMap<ImmutableContextSet, SortedSet<Node>> map() {
        return this.map;
    }

    @Override
    protected SortedMap<ImmutableContextSet, SortedSet<InheritanceNode>> inheritanceMap() {
        return this.inheritanceMap;
    }

    @Override
    protected ContextSatisfyMode defaultSatisfyMode() {
        return this.holder.getPlugin().getConfiguration().get(ConfigKeys.CONTEXT_SATISFY_MODE);
    }

    private Node addInheritanceOrigin(Node node) {
        Optional<InheritanceOriginMetadata> existing = node.getMetadata(InheritanceOriginMetadata.KEY);
        if (existing.isPresent() && existing.get().equals(this.inheritanceOrigin)) {
            return node;
        }
        return node.toBuilder().withMetadata(InheritanceOriginMetadata.KEY, this.inheritanceOrigin).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> add(Node nodeWithoutInheritanceOrigin) {
        Node node = this.addInheritanceOrigin(nodeWithoutInheritanceOrigin);
        ImmutableContextSet context = node.getContexts();
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            SortedSet<Node> nodes = this.map.computeIfAbsent(context, VALUE_SET_SUPPLIER);
            if (!nodes.add(node)) {
                Difference<Node> difference = result;
                return difference;
            }
            result.recordChange(Difference.ChangeType.ADD, node);
            NodeMapMutable.removeMatchingButNotSame(nodes.iterator(), node, result);
            if (node instanceof InheritanceNode) {
                SortedSet<InheritanceNode> inhNodes = this.inheritanceMap.computeIfAbsent(context, INHERITANCE_VALUE_SET_SUPPLIER);
                inhNodes.removeIf((? super E el) -> node.equals((Node)el, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE));
                if (node.getValue()) {
                    inhNodes.add((InheritanceNode)node);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> remove(Node node) {
        ImmutableContextSet context = node.getContexts();
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            SortedSet inhNodes;
            SortedSet nodes = (SortedSet)this.map.get(context);
            if (nodes == null) {
                Difference<Node> difference = result;
                return difference;
            }
            NodeMapMutable.removeMatching(nodes.iterator(), node, result);
            if (node instanceof InheritanceNode && (inhNodes = (SortedSet)this.inheritanceMap.get(context)) != null) {
                inhNodes.removeIf((? super E el) -> node.equals((Node)el, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE));
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    private static void removeMatching(Iterator<Node> it, Node node, Difference<Node> result) {
        while (it.hasNext()) {
            Node el = it.next();
            if (!node.equals(el, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE)) continue;
            it.remove();
            result.recordChange(Difference.ChangeType.REMOVE, el);
        }
    }

    private static void removeMatchingButNotSame(Iterator<Node> it, Node node, Difference<Node> result) {
        while (it.hasNext()) {
            Node el = it.next();
            if (el == node || !node.equals(el, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE)) continue;
            it.remove();
            result.recordChange(Difference.ChangeType.REMOVE, el);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> removeExact(Node node) {
        ImmutableContextSet context = node.getContexts();
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            SortedSet nodes = (SortedSet)this.map.get(context);
            if (nodes == null) {
                Difference<Node> difference = result;
                return difference;
            }
            if (nodes.remove(node)) {
                SortedSet inhNodes;
                result.recordChange(Difference.ChangeType.REMOVE, node);
                if (node instanceof InheritanceNode && node.getValue() && (inhNodes = (SortedSet)this.inheritanceMap.get(context)) != null) {
                    inhNodes.remove(node);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> removeIf(Predicate<? super Node> predicate) {
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            for (SortedSet<Node> nodes : this.map.values()) {
                this.removeMatching(nodes.iterator(), predicate, result);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> removeIf(ContextSet contextSet, Predicate<? super Node> predicate) {
        ImmutableContextSet context = contextSet.immutableCopy();
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            SortedSet nodes = (SortedSet)this.map.get(context);
            if (nodes == null) {
                Difference<Node> difference = result;
                return difference;
            }
            this.removeMatching(nodes.iterator(), predicate, result);
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    private void removeMatching(Iterator<Node> it, Predicate<? super Node> predicate, Difference<Node> result) {
        while (it.hasNext()) {
            SortedSet inhNodes;
            Node node = it.next();
            if (!predicate.test(node)) continue;
            it.remove();
            result.recordChange(Difference.ChangeType.REMOVE, node);
            if (!(node instanceof InheritanceNode) || !node.getValue() || (inhNodes = (SortedSet)this.inheritanceMap.get(node.getContexts())) == null) continue;
            inhNodes.remove(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> removeThenAdd(Node nodeToRemove, Node nodeToAdd) {
        if (nodeToAdd.equals(nodeToRemove)) {
            return new Difference<Node>();
        }
        this.lock.lock();
        try {
            Difference<Node> difference = this.removeExact(nodeToRemove).mergeFrom(this.add(nodeToAdd));
            return difference;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> clear() {
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            for (SortedSet<Node> nodes : this.map.values()) {
                result.recordChanges(Difference.ChangeType.REMOVE, nodes);
            }
            this.map = NodeMapMutable.createMap();
            this.inheritanceMap = NodeMapMutable.createMap();
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> clear(ContextSet contextSet) {
        ImmutableContextSet context = contextSet.immutableCopy();
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            SortedSet removed = (SortedSet)this.map.remove(context);
            if (removed != null) {
                result.recordChanges(Difference.ChangeType.REMOVE, removed);
                this.inheritanceMap.remove(context);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public Difference<Node> setContent(Iterable<? extends Node> set) {
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            result.mergeFrom(this.clear());
            result.mergeFrom(this.addAll(set));
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public Difference<Node> setContent(Stream<? extends Node> stream) {
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            result.mergeFrom(this.clear());
            result.mergeFrom(this.addAll(stream));
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> applyChanges(Difference<Node> changes) {
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            for (Node n : changes.getAdded()) {
                result.mergeFrom(this.add(n));
            }
            for (Node n : changes.getRemoved()) {
                result.mergeFrom(this.removeExact(n));
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Difference<Node> addAll(Iterable<? extends Node> set) {
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            for (Node node : set) {
                result.mergeFrom(this.add(node));
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public Difference<Node> addAll(Stream<? extends Node> stream) {
        Difference<Node> result = new Difference<Node>();
        this.lock.lock();
        try {
            stream.forEach((? super T n) -> result.mergeFrom(this.add((Node)n)));
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }
}

