/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.factory;

import me.lucko.luckperms.common.model.HolderType;
import net.luckperms.api.context.Context;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.MetaNode;

public final class NodeCommandFactory {
    private NodeCommandFactory() {
    }

    public static String undoCommand(Node node, String holder, HolderType holderType, boolean explicitGlobalContext) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(holderType.toString()).append(' ').append(holder).append(' ');
        if (node instanceof InheritanceNode) {
            sb.append("parent remove");
            if (node.hasExpiry()) {
                sb.append("temp");
            }
            sb.append(' ');
            sb.append(((InheritanceNode)node).getGroupName());
        } else if (node.getValue() && node instanceof ChatMetaNode) {
            ChatMetaNode chatNode = (ChatMetaNode)node;
            sb.append("meta remove");
            if (node.hasExpiry()) {
                sb.append("temp");
            }
            sb.append(chatNode.getMetaType().toString());
            sb.append(' ').append(chatNode.getPriority()).append(' ');
            NodeCommandFactory.appendEscaped(sb, chatNode.getMetaValue());
        } else if (node.getValue() && node instanceof MetaNode) {
            MetaNode metaNode = (MetaNode)node;
            sb.append("meta unset");
            if (node.hasExpiry()) {
                sb.append("temp");
            }
            sb.append(' ');
            NodeCommandFactory.appendEscaped(sb, metaNode.getMetaKey());
        } else {
            sb.append("permission unset");
            if (node.hasExpiry()) {
                sb.append("temp");
            }
            sb.append(' ');
            NodeCommandFactory.appendEscaped(sb, node.getKey());
        }
        if (!node.getContexts().isEmpty()) {
            for (Context context : node.getContexts()) {
                sb.append(' ').append(context.getKey()).append("=").append(context.getValue());
            }
        } else if (explicitGlobalContext) {
            sb.append(" global");
        }
        return sb.toString();
    }

    private static void appendEscaped(StringBuilder sb, String value) {
        if (value.indexOf(32) != -1 || value.isEmpty()) {
            sb.append("\"").append(value).append("\"");
        } else {
            sb.append(value);
        }
    }
}

