/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.mongodb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.actionlog.LogPage;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.actionlog.filter.ActionFilterMongoBuilder;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.context.MutableContextSetImpl;
import me.lucko.luckperms.common.filter.FilterList;
import me.lucko.luckperms.common.filter.PageParameters;
import me.lucko.luckperms.common.filter.mongo.ConstraintMongoBuilder;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.StorageMetadata;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.storage.misc.PlayerSaveResultImpl;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.lib.bson.Document;
import me.lucko.luckperms.lib.bson.UuidRepresentation;
import me.lucko.luckperms.lib.bson.conversions.Bson;
import me.lucko.luckperms.lib.mongodb.MongoClient;
import me.lucko.luckperms.lib.mongodb.MongoClientOptions;
import me.lucko.luckperms.lib.mongodb.MongoClientURI;
import me.lucko.luckperms.lib.mongodb.MongoCredential;
import me.lucko.luckperms.lib.mongodb.ServerAddress;
import me.lucko.luckperms.lib.mongodb.client.MongoCollection;
import me.lucko.luckperms.lib.mongodb.client.MongoCursor;
import me.lucko.luckperms.lib.mongodb.client.MongoDatabase;
import me.lucko.luckperms.lib.mongodb.client.model.Filters;
import me.lucko.luckperms.lib.mongodb.client.model.ReplaceOptions;
import me.lucko.luckperms.lib.mongodb.client.model.Sorts;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.node.Node;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MongoStorage
implements StorageImplementation {
    private final LuckPermsPlugin plugin;
    private final StorageCredentials configuration;
    private MongoClient mongoClient;
    private MongoDatabase database;
    private final String prefix;
    private final String connectionUri;

    public MongoStorage(LuckPermsPlugin plugin, StorageCredentials configuration, String prefix, String connectionUri) {
        this.plugin = plugin;
        this.configuration = configuration;
        this.prefix = prefix;
        this.connectionUri = connectionUri;
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "MongoDB";
    }

    @Override
    public void init() {
        MongoClientOptions.Builder options = MongoClientOptions.builder().uuidRepresentation(UuidRepresentation.JAVA_LEGACY);
        if (!Strings.isNullOrEmpty((String)this.connectionUri)) {
            this.mongoClient = new MongoClient(new MongoClientURI(this.connectionUri, options));
        } else {
            MongoCredential credential = null;
            if (!Strings.isNullOrEmpty((String)this.configuration.getUsername())) {
                credential = MongoCredential.createCredential((String)this.configuration.getUsername(), (String)this.configuration.getDatabase(), Strings.isNullOrEmpty((String)this.configuration.getPassword()) ? null : this.configuration.getPassword().toCharArray());
            }
            String[] addressSplit = this.configuration.getAddress().split(":");
            String host = addressSplit[0];
            int port = addressSplit.length > 1 ? Integer.parseInt(addressSplit[1]) : 27017;
            ServerAddress address = new ServerAddress(host, port);
            this.mongoClient = credential == null ? new MongoClient(address, options.build()) : new MongoClient(address, credential, options.build());
        }
        this.database = this.mongoClient.getDatabase(this.configuration.getDatabase());
    }

    @Override
    public void shutdown() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Override
    public StorageMetadata getMeta() {
        StorageMetadata metadata = new StorageMetadata();
        boolean success = true;
        long start = System.currentTimeMillis();
        try {
            this.database.runCommand((Bson)new Document("ping", (Object)1));
        }
        catch (Exception e) {
            success = false;
        }
        if (success) {
            int duration = (int)(System.currentTimeMillis() - start);
            metadata.ping(duration);
        }
        metadata.connected(success);
        return metadata;
    }

    @Override
    public void logAction(Action entry) {
        MongoCollection c = this.database.getCollection(this.prefix + "action");
        c.insertOne((Object)MongoStorage.actionToDoc(entry));
    }

    @Override
    public LogPage getLogPage(FilterList<Action> filters, @Nullable PageParameters page) throws Exception {
        Bson filter = ActionFilterMongoBuilder.INSTANCE.make(filters);
        MongoCollection c = this.database.getCollection(this.prefix + "action");
        long count = c.countDocuments(filter);
        ArrayList<LoggedAction> content = new ArrayList<LoggedAction>();
        try (MongoCursor cursor = ConstraintMongoBuilder.page(page, c.find(filter).sort(Sorts.descending((String[])new String[]{"timestamp", "_id"}))).iterator();){
            while (cursor.hasNext()) {
                content.add(MongoStorage.actionFromDoc((Document)cursor.next()));
            }
        }
        return LogPage.of(content, page, (int)count);
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) {
        Document results;
        Document d;
        MongoCursor cursor;
        MongoCollection c;
        if (bulkUpdate.getDataType().isIncludingUsers()) {
            c = this.database.getCollection(this.prefix + "users");
            cursor = c.find().iterator();
            try {
                while (cursor.hasNext()) {
                    d = (Document)cursor.next();
                    UUID uuid = MongoStorage.getDocumentId(d);
                    results = this.processBulkUpdate(d, bulkUpdate, HolderType.USER);
                    if (results == null) continue;
                    c.replaceOne(Filters.eq((String)"_id", (Object)uuid), (Object)results);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        if (bulkUpdate.getDataType().isIncludingGroups()) {
            c = this.database.getCollection(this.prefix + "groups");
            cursor = c.find().iterator();
            try {
                while (cursor.hasNext()) {
                    d = (Document)cursor.next();
                    String holder = d.getString((Object)"_id");
                    results = this.processBulkUpdate(d, bulkUpdate, HolderType.GROUP);
                    if (results == null) continue;
                    c.replaceOne(Filters.eq((String)"_id", (Object)holder), (Object)results);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private Document processBulkUpdate(Document document, BulkUpdate bulkUpdate, HolderType holderType) {
        HashSet<Node> nodes = new HashSet<Node>(MongoStorage.nodesFromDoc(document));
        Set<Node> results = bulkUpdate.apply(nodes, holderType);
        if (results == null) {
            return null;
        }
        List newNodes = results.stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
        document.append("permissions", newNodes).remove((Object)"perms");
        return document;
    }

    @Override
    public User loadUser(UUID uniqueId, String username) {
        User user = this.plugin.getUserManager().getOrMake(uniqueId, username);
        MongoCollection c = this.database.getCollection(this.prefix + "users");
        try (MongoCursor cursor = c.find(Filters.eq((String)"_id", (Object)user.getUniqueId())).iterator();){
            if (cursor.hasNext()) {
                boolean updatedUsername;
                Document d = (Document)cursor.next();
                String name = d.getString((Object)"name");
                user.getPrimaryGroup().setStoredValue(d.getString((Object)"primaryGroup"));
                user.setUsername(name, true);
                user.loadNodesFromStorage(MongoStorage.nodesFromDoc(d));
                this.plugin.getUserManager().giveDefaultIfNeeded(user);
                boolean bl = updatedUsername = user.getUsername().isPresent() && (name == null || !user.getUsername().get().equalsIgnoreCase(name));
                if (updatedUsername | user.auditTemporaryNodes()) {
                    c.replaceOne(Filters.eq((String)"_id", (Object)user.getUniqueId()), (Object)MongoStorage.userToDoc(user));
                }
            } else if (this.plugin.getUserManager().isNonDefaultUser(user)) {
                user.loadNodesFromStorage(Collections.emptyList());
                user.getPrimaryGroup().setStoredValue(null);
                this.plugin.getUserManager().giveDefaultIfNeeded(user);
            }
        }
        return user;
    }

    @Override
    public Map<UUID, User> loadUsers(Set<UUID> uniqueIds) throws Exception {
        HashMap<UUID, User> map = new HashMap<UUID, User>();
        for (UUID uniqueId : uniqueIds) {
            map.put(uniqueId, this.loadUser(uniqueId, null));
        }
        return map;
    }

    @Override
    public void saveUser(User user) {
        MongoCollection c = this.database.getCollection(this.prefix + "users");
        user.normalData().discardChanges();
        if (!this.plugin.getUserManager().isNonDefaultUser(user)) {
            c.deleteOne(Filters.eq((String)"_id", (Object)user.getUniqueId()));
        } else {
            c.replaceOne(Filters.eq((String)"_id", (Object)user.getUniqueId()), (Object)MongoStorage.userToDoc(user), new ReplaceOptions().upsert(true));
        }
    }

    @Override
    public Set<UUID> getUniqueUsers() {
        HashSet<UUID> uuids = new HashSet<UUID>();
        MongoCollection c = this.database.getCollection(this.prefix + "users");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                try {
                    uuids.add(MongoStorage.getDocumentId((Document)cursor.next()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return uuids;
    }

    @Override
    public <N extends Node> List<NodeEntry<UUID, N>> searchUserNodes(ConstraintNodeMatcher<N> constraint) throws Exception {
        ArrayList<NodeEntry<UUID, N>> held = new ArrayList<NodeEntry<UUID, N>>();
        MongoCollection c = this.database.getCollection(this.prefix + "users");
        try (MongoCursor cursor = c.find(Filters.elemMatch((String)"permissions", (Bson)ConstraintMongoBuilder.INSTANCE.make(constraint.getConstraint(), "key"))).iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                UUID holder = MongoStorage.getDocumentId(d);
                HashSet<Node> nodes = new HashSet<Node>(MongoStorage.nodesFromDoc(d));
                for (Node e : nodes) {
                    N match = constraint.match(e);
                    if (match == null) continue;
                    held.add(NodeEntry.of(holder, match));
                }
            }
        }
        return held;
    }

    @Override
    public Group createAndLoadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        try (MongoCursor cursor = c.find(Filters.eq((String)"_id", (Object)group.getName())).iterator();){
            if (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                group.loadNodesFromStorage(MongoStorage.nodesFromDoc(d));
            } else {
                c.insertOne((Object)MongoStorage.groupToDoc(group));
            }
        }
        return group;
    }

    @Override
    public Optional<Group> loadGroup(String name) {
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        try (MongoCursor cursor = c.find(Filters.eq((String)"_id", (Object)name)).iterator();){
            if (!cursor.hasNext()) {
                Optional<Group> optional = Optional.empty();
                return optional;
            }
            Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
            Document d = (Document)cursor.next();
            group.loadNodesFromStorage(MongoStorage.nodesFromDoc(d));
            Optional<Group> optional = Optional.of(group);
            return optional;
        }
    }

    @Override
    public void loadAllGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                String name = ((Document)cursor.next()).getString((Object)"_id");
                groups.add(name);
            }
        }
        if (!Iterators.tryIterate(groups, this::loadGroup)) {
            throw new RuntimeException("Exception occurred whilst loading a group");
        }
        this.plugin.getGroupManager().retainAll(groups);
    }

    @Override
    public void saveGroup(Group group) {
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        group.normalData().discardChanges();
        c.replaceOne(Filters.eq((String)"_id", (Object)group.getName()), (Object)MongoStorage.groupToDoc(group), new ReplaceOptions().upsert(true));
    }

    @Override
    public void deleteGroup(Group group) {
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        c.deleteOne(Filters.eq((String)"_id", (Object)group.getName()));
    }

    @Override
    public <N extends Node> List<NodeEntry<String, N>> searchGroupNodes(ConstraintNodeMatcher<N> constraint) throws Exception {
        ArrayList<NodeEntry<String, N>> held = new ArrayList<NodeEntry<String, N>>();
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        try (MongoCursor cursor = c.find(Filters.elemMatch((String)"permissions", (Bson)ConstraintMongoBuilder.INSTANCE.make(constraint.getConstraint(), "key"))).iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                String holder = d.getString((Object)"_id");
                HashSet<Node> nodes = new HashSet<Node>(MongoStorage.nodesFromDoc(d));
                for (Node e : nodes) {
                    N match = constraint.match(e);
                    if (match == null) continue;
                    held.add(NodeEntry.of(holder, match));
                }
            }
        }
        return held;
    }

    @Override
    public Track createAndLoadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
        MongoCollection c = this.database.getCollection(this.prefix + "tracks");
        try (MongoCursor cursor = c.find(Filters.eq((String)"_id", (Object)track.getName())).iterator();){
            if (!cursor.hasNext()) {
                c.insertOne((Object)MongoStorage.trackToDoc(track));
            } else {
                Document d = (Document)cursor.next();
                track.setGroups((List)d.get((Object)"groups"));
            }
        }
        return track;
    }

    @Override
    public Optional<Track> loadTrack(String name) {
        MongoCollection c = this.database.getCollection(this.prefix + "tracks");
        try (MongoCursor cursor = c.find(Filters.eq((String)"_id", (Object)name)).iterator();){
            if (!cursor.hasNext()) {
                Optional<Track> optional = Optional.empty();
                return optional;
            }
            Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
            Document d = (Document)cursor.next();
            track.setGroups((List)d.get((Object)"groups"));
            Optional<Track> optional = Optional.of(track);
            return optional;
        }
    }

    @Override
    public void loadAllTracks() {
        ArrayList<String> tracks = new ArrayList<String>();
        MongoCollection c = this.database.getCollection(this.prefix + "tracks");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                String name = ((Document)cursor.next()).getString((Object)"_id");
                tracks.add(name);
            }
        }
        if (!Iterators.tryIterate(tracks, this::loadTrack)) {
            throw new RuntimeException("Exception occurred whilst loading a track");
        }
        this.plugin.getTrackManager().retainAll(tracks);
    }

    @Override
    public void saveTrack(Track track) {
        MongoCollection c = this.database.getCollection(this.prefix + "tracks");
        c.replaceOne(Filters.eq((String)"_id", (Object)track.getName()), (Object)MongoStorage.trackToDoc(track));
    }

    @Override
    public void deleteTrack(Track track) {
        MongoCollection c = this.database.getCollection(this.prefix + "tracks");
        c.deleteOne(Filters.eq((String)"_id", (Object)track.getName()));
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uniqueId, String username) {
        username = username.toLowerCase(Locale.ROOT);
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        String oldUsername = this.getPlayerName(uniqueId);
        if (!username.equalsIgnoreCase(oldUsername)) {
            c.replaceOne(Filters.eq((String)"_id", (Object)uniqueId), (Object)new Document("_id", (Object)uniqueId).append("name", (Object)username), new ReplaceOptions().upsert(true));
        }
        PlayerSaveResultImpl result = PlayerSaveResultImpl.determineBaseResult(username, oldUsername);
        HashSet<UUID> conflicting = new HashSet<UUID>();
        try (MongoCursor cursor = c.find(Filters.eq((String)"name", (Object)username)).iterator();){
            while (cursor.hasNext()) {
                conflicting.add(MongoStorage.getDocumentId((Document)cursor.next()));
            }
        }
        conflicting.remove(uniqueId);
        if (!conflicting.isEmpty()) {
            c.deleteMany(Filters.or((Iterable)conflicting.stream().map(u -> Filters.eq((String)"_id", (Object)u)).collect(Collectors.toList())));
            result = result.withOtherUuidsPresent(conflicting);
        }
        return result;
    }

    @Override
    public void deletePlayerData(UUID uniqueId) {
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        c.deleteMany(Filters.eq((String)"_id", (Object)uniqueId));
    }

    @Override
    public UUID getPlayerUniqueId(String username) {
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        Document doc = (Document)c.find(Filters.eq((String)"name", (Object)username.toLowerCase(Locale.ROOT))).first();
        if (doc != null) {
            return MongoStorage.getDocumentId(doc);
        }
        return null;
    }

    @Override
    public String getPlayerName(UUID uniqueId) {
        String username;
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        Document doc = (Document)c.find(Filters.eq((String)"_id", (Object)uniqueId)).first();
        if (doc != null && (username = (String)doc.get((Object)"name", String.class)) != null && !username.equals("null")) {
            return username;
        }
        return null;
    }

    private static UUID getDocumentId(Document document) {
        Object id = document.get((Object)"_id");
        if (id instanceof UUID) {
            return (UUID)id;
        }
        if (id instanceof String) {
            return UUID.fromString((String)id);
        }
        throw new IllegalArgumentException("Unknown id type: " + id.getClass().getName());
    }

    private static Document userToDoc(User user) {
        List nodes = user.normalData().asList().stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
        return new Document("_id", (Object)user.getUniqueId()).append("name", (Object)user.getUsername().orElse("null")).append("primaryGroup", (Object)user.getPrimaryGroup().getStoredValue().orElse("default")).append("permissions", nodes);
    }

    private static List<Node> nodesFromDoc(Document document) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (document.containsKey((Object)"permissions") && document.get((Object)"permissions") instanceof List) {
            List permsList = (List)document.get((Object)"permissions");
            for (Document d : permsList) {
                Node node = MongoStorage.nodeFromDoc(d);
                if (node == null) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    private static Document groupToDoc(Group group) {
        List nodes = group.normalData().asList().stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
        return new Document("_id", (Object)group.getName()).append("permissions", nodes);
    }

    private static Document trackToDoc(Track track) {
        return new Document("_id", (Object)track.getName()).append("groups", track.getGroups());
    }

    @VisibleForTesting
    static Document nodeToDoc(Node node) {
        Document document = new Document().append("key", (Object)node.getKey()).append("value", (Object)node.getValue());
        Instant expiry = node.getExpiry();
        if (expiry != null) {
            document.append("expiry", (Object)expiry.getEpochSecond());
        }
        if (!node.getContexts().isEmpty()) {
            document.append("context", MongoStorage.contextSetToDocs(node.getContexts()));
        }
        return document;
    }

    @VisibleForTesting
    static Node nodeFromDoc(Document document) {
        String key;
        String string = key = document.containsKey((Object)"permission") ? document.getString((Object)"permission") : document.getString((Object)"key");
        if (key == null || key.isEmpty()) {
            return null;
        }
        Object builder = NodeBuilders.determineMostApplicable(key).value(document.getBoolean((Object)"value", true));
        if (document.containsKey((Object)"server")) {
            builder.withContext("server", document.getString((Object)"server"));
        }
        if (document.containsKey((Object)"world")) {
            builder.withContext("world", document.getString((Object)"world"));
        }
        if (document.containsKey((Object)"expiry")) {
            builder.expiry(((Number)document.get((Object)"expiry")).longValue());
        }
        if (document.containsKey((Object)"context") && document.get((Object)"context") instanceof List) {
            List contexts = (List)document.get((Object)"context");
            builder.withContext(MongoStorage.docsToContextSet(contexts));
        }
        return builder.build();
    }

    private static List<Document> contextSetToDocs(ContextSet contextSet) {
        ArrayList<Document> contexts = new ArrayList<Document>(contextSet.size());
        for (Context e : contextSet) {
            contexts.add(new Document().append("key", (Object)e.getKey()).append("value", (Object)e.getValue()));
        }
        return contexts;
    }

    private static MutableContextSet docsToContextSet(List<Document> documents) {
        MutableContextSetImpl map = new MutableContextSetImpl();
        for (Document doc : documents) {
            map.add(doc.getString((Object)"key"), doc.getString((Object)"value"));
        }
        return map;
    }

    private static Document actionToDoc(Action action) {
        Document source = new Document().append("uniqueId", (Object)action.getSource().getUniqueId()).append("name", (Object)action.getSource().getName());
        Document target = new Document().append("type", (Object)action.getTarget().getType().name()).append("name", (Object)action.getTarget().getName());
        if (action.getTarget().getUniqueId().isPresent()) {
            target.append("uniqueId", (Object)action.getTarget().getUniqueId().get());
        }
        return new Document().append("timestamp", (Object)action.getTimestamp().getEpochSecond()).append("source", (Object)source).append("target", (Object)target).append("description", (Object)action.getDescription());
    }

    private static LoggedAction actionFromDoc(Document d) {
        if (d.containsKey((Object)"source")) {
            Document source = (Document)d.get((Object)"source", Document.class);
            Document target = (Document)d.get((Object)"target", Document.class);
            UUID targetUniqueId = null;
            if (target.containsKey((Object)"uniqueId")) {
                targetUniqueId = (UUID)target.get((Object)"uniqueId", UUID.class);
            }
            return LoggedAction.build().timestamp(Instant.ofEpochSecond(d.getLong((Object)"timestamp"))).source((UUID)source.get((Object)"uniqueId", UUID.class)).sourceName(source.getString((Object)"name")).targetType(LoggedAction.parseType(target.getString((Object)"type"))).target(targetUniqueId).targetName(target.getString((Object)"name")).description(d.getString((Object)"description")).build();
        }
        UUID actedUuid = null;
        if (d.containsKey((Object)"acted")) {
            actedUuid = (UUID)d.get((Object)"acted", UUID.class);
        }
        return LoggedAction.build().timestamp(Instant.ofEpochSecond(d.getLong((Object)"timestamp"))).source((UUID)d.get((Object)"actor", UUID.class)).sourceName(d.getString((Object)"actorName")).targetType(LoggedAction.parseTypeCharacter(d.getString((Object)"type").charAt(0))).target(actedUuid).targetName(d.getString((Object)"actedName")).description(d.getString((Object)"action")).build();
    }
}

