/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.lucko.luckperms.common.storage.implementation.sql.StatementProcessor;

public class PreparedStatementBuilder {
    private final StringBuilder sb = new StringBuilder();
    private final List<String> variables = new ArrayList<String>();

    public PreparedStatementBuilder append(String s) {
        this.sb.append(s);
        return this;
    }

    public PreparedStatementBuilder append(char c) {
        this.sb.append(c);
        return this;
    }

    public PreparedStatementBuilder variable(String variable) {
        this.sb.append('?');
        this.variables.add(variable);
        return this;
    }

    public PreparedStatement build(Connection connection, StatementProcessor processor) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.prepareStatement(processor.process(this.sb.toString()));
            for (int i = 0; i < this.variables.size(); ++i) {
                String var = this.variables.get(i);
                statement.setString(i + 1, var);
            }
            return statement;
        }
        catch (SQLException e) {
            if (statement != null) {
                statement.close();
            }
            throw e;
        }
    }

    public String toReadableString() {
        String s = this.sb.toString();
        for (String var : this.variables) {
            s = s.replaceFirst("\\?", var);
        }
        return s;
    }

    public String toQueryString() {
        return this.sb.toString();
    }
}

