/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.misc;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.luckperms.api.model.PlayerSaveResult;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlayerSaveResultImpl
implements PlayerSaveResult {
    private static final PlayerSaveResultImpl CLEAN_INSERT = new PlayerSaveResultImpl(PlayerSaveResult.Outcome.CLEAN_INSERT);
    private static final PlayerSaveResultImpl NO_CHANGE = new PlayerSaveResultImpl(PlayerSaveResult.Outcome.NO_CHANGE);
    private final Set<PlayerSaveResult.Outcome> outcomes;
    private final @Nullable String previousUsername;
    private final @Nullable Set<UUID> otherUuids;

    public static PlayerSaveResultImpl cleanInsert() {
        return CLEAN_INSERT;
    }

    public static PlayerSaveResultImpl noChange() {
        return NO_CHANGE;
    }

    public static PlayerSaveResultImpl usernameUpdated(String oldUsername) {
        return new PlayerSaveResultImpl(EnumSet.of(PlayerSaveResult.Outcome.USERNAME_UPDATED), oldUsername, null);
    }

    public static PlayerSaveResultImpl determineBaseResult(String username, String oldUsername) {
        PlayerSaveResultImpl result = oldUsername == null ? PlayerSaveResultImpl.cleanInsert() : (oldUsername.equalsIgnoreCase(username) ? PlayerSaveResultImpl.noChange() : PlayerSaveResultImpl.usernameUpdated(oldUsername));
        return result;
    }

    private PlayerSaveResultImpl(EnumSet<PlayerSaveResult.Outcome> outcomes, @Nullable String previousUsername, @Nullable Set<UUID> otherUuids) {
        this.outcomes = ImmutableSet.copyOf(outcomes);
        this.previousUsername = previousUsername;
        this.otherUuids = otherUuids;
    }

    private PlayerSaveResultImpl(PlayerSaveResult.Outcome outcome) {
        this(EnumSet.of(outcome), null, null);
    }

    public PlayerSaveResultImpl withOtherUuidsPresent(@NonNull Set<UUID> otherUuids) {
        EnumSet<PlayerSaveResult.Outcome> outcomes = EnumSet.copyOf(this.outcomes);
        outcomes.add(PlayerSaveResult.Outcome.OTHER_UNIQUE_IDS_PRESENT_FOR_USERNAME);
        return new PlayerSaveResultImpl(outcomes, this.previousUsername, (Set<UUID>)ImmutableSet.copyOf(otherUuids));
    }

    @Override
    public @NonNull Set<PlayerSaveResult.Outcome> getOutcomes() {
        return this.outcomes;
    }

    @Override
    public @Nullable String getPreviousUsername() {
        return this.previousUsername;
    }

    @Override
    public @Nullable Set<UUID> getOtherUniqueIds() {
        return this.otherUuids;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        PlayerSaveResultImpl result = (PlayerSaveResultImpl)that;
        return Objects.equals(this.outcomes, result.outcomes) && Objects.equals(this.previousUsername, result.previousUsername) && Objects.equals(this.otherUuids, result.otherUuids);
    }

    public int hashCode() {
        return Objects.hash(this.outcomes, this.previousUsername, this.otherUuids);
    }

    public String toString() {
        return "PlayerSaveResult(outcomes=" + String.valueOf(this.outcomes) + ", previousUsername=" + this.previousUsername + ", otherUuids=" + String.valueOf(this.otherUuids) + ")";
    }
}

