/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class Difference<T> {
    private final LinkedHashSet<Change<T>> changes = new LinkedHashSet();

    public Set<Change<T>> getChanges() {
        return this.changes;
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public Set<T> getChanges(ChangeType type) {
        LinkedHashSet changes = new LinkedHashSet(this.changes.size());
        for (Change change : this.changes) {
            if (change.type() != type) continue;
            changes.add(change.value());
        }
        return changes;
    }

    public Set<T> getAdded() {
        return this.getChanges(ChangeType.ADD);
    }

    public Set<T> getRemoved() {
        return this.getChanges(ChangeType.REMOVE);
    }

    public void clear() {
        this.changes.clear();
    }

    private void recordChange(Change<T> change) {
        if (this.changes.remove(change.inverse())) {
            return;
        }
        this.changes.add(change);
    }

    public void recordChange(ChangeType type, T value) {
        this.recordChange(new Change<T>(type, value));
    }

    public void recordChanges(ChangeType type, Iterable<T> values) {
        for (T value : values) {
            this.recordChange(new Change<T>(type, value));
        }
    }

    public Difference<T> mergeFrom(Difference<T> other) {
        for (Change change : other.changes) {
            this.recordChange(change);
        }
        return this;
    }

    public String toString() {
        return "Difference{" + String.valueOf(this.changes) + "}";
    }

    public static final class Change<T> {
        private final ChangeType type;
        private final T value;

        public Change(ChangeType type, T value) {
            this.type = type;
            this.value = value;
        }

        public ChangeType type() {
            return this.type;
        }

        public T value() {
            return this.value;
        }

        public Change<T> inverse() {
            return new Change<T>(this.type.inverse(), this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Change change = (Change)o;
            return this.type == change.type && this.value.equals(change.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        public String toString() {
            return "(" + String.valueOf((Object)this.type) + ": " + String.valueOf(this.value) + ")";
        }
    }

    public static enum ChangeType {
        ADD,
        REMOVE;


        public ChangeType inverse() {
            return this == ADD ? REMOVE : ADD;
        }
    }
}

