/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.cacheddata.result.StringResult;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.verbose.VerboseCheckTarget;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.verbose.VerboseListener;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import me.lucko.luckperms.common.verbose.event.PermissionCheckEvent;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import net.luckperms.api.query.QueryOptions;

public class VerboseHandler
implements AutoCloseable {
    private final Map<UUID, VerboseListener> listeners = new ConcurrentHashMap<UUID, VerboseListener>();
    private final Queue<VerboseEvent> queue = new ConcurrentLinkedQueue<VerboseEvent>();
    private boolean listening = false;
    private final SchedulerTask task;

    public VerboseHandler(SchedulerAdapter scheduler) {
        this.task = scheduler.asyncRepeating(this::tick, 100L, TimeUnit.MILLISECONDS);
    }

    public void offerPermissionCheckEvent(CheckOrigin origin, VerboseCheckTarget checkTarget, QueryOptions checkQueryOptions, String permission, TristateResult result) {
        if (!this.listening) {
            return;
        }
        long time = System.currentTimeMillis();
        Throwable trace = new Throwable();
        String thread = Thread.currentThread().getName();
        this.queue.offer(new PermissionCheckEvent(origin, checkTarget, checkQueryOptions, time, trace, thread, permission, result));
    }

    public void offerMetaCheckEvent(CheckOrigin origin, VerboseCheckTarget checkTarget, QueryOptions checkQueryOptions, String key, StringResult<?> result) {
        if (!this.listening) {
            return;
        }
        long time = System.currentTimeMillis();
        Throwable trace = new Throwable();
        String thread = Thread.currentThread().getName();
        this.queue.offer(new MetaCheckEvent(origin, checkTarget, checkQueryOptions, time, trace, thread, key, result));
    }

    public void registerListener(Sender sender, VerboseFilter filter, boolean notify) {
        this.flush();
        this.listeners.put(sender.getUniqueId(), new VerboseListener(sender, filter, notify));
        this.listening = true;
    }

    public VerboseListener unregisterListener(Sender sender) {
        this.flush();
        return this.listeners.remove(sender.getUniqueId());
    }

    private void tick() {
        this.listeners.values().removeIf(l -> !l.getNotifiedSender().isValid());
        this.flush();
        this.listening = !this.listeners.isEmpty();
    }

    public synchronized void flush() {
        VerboseEvent e;
        while ((e = this.queue.poll()) != null) {
            for (VerboseListener listener : this.listeners.values()) {
                listener.acceptEvent(e);
            }
        }
    }

    @Override
    public void close() {
        this.task.cancel();
    }
}

