/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import me.lucko.luckperms.common.plugin.bootstrap.LuckPermsBootstrap;
import me.lucko.luckperms.common.plugin.classpath.ClassPathAppender;
import me.lucko.luckperms.common.plugin.logging.Log4jPluginLogger;
import me.lucko.luckperms.common.plugin.logging.PluginLogger;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.fabric.FabricClassPathAppender;
import me.lucko.luckperms.fabric.FabricSchedulerAdapter;
import me.lucko.luckperms.fabric.LPFabricPlugin;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.luckperms.api.platform.Platform;
import net.minecraft.class_11560;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;

public final class LPFabricBootstrap
implements LuckPermsBootstrap,
DedicatedServerModInitializer {
    private static final String MODID = "luckperms";
    private final ModContainer modContainer;
    private final PluginLogger logger;
    private final SchedulerAdapter schedulerAdapter;
    private final ClassPathAppender classPathAppender;
    private LPFabricPlugin plugin;
    private Instant startTime;
    private final CountDownLatch loadLatch = new CountDownLatch(1);
    private final CountDownLatch enableLatch = new CountDownLatch(1);
    private MinecraftServer server;

    public LPFabricBootstrap() {
        this.modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow(() -> new RuntimeException("Could not get the LuckPerms mod container."));
        this.logger = new Log4jPluginLogger(LogManager.getLogger((String)MODID));
        this.schedulerAdapter = new FabricSchedulerAdapter(this);
        this.classPathAppender = new FabricClassPathAppender();
        this.plugin = new LPFabricPlugin(this);
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public SchedulerAdapter getScheduler() {
        return this.schedulerAdapter;
    }

    @Override
    public ClassPathAppender getClassPathAppender() {
        return this.classPathAppender;
    }

    public void onInitializeServer() {
        this.plugin = new LPFabricPlugin(this);
        try {
            this.plugin.load();
        }
        finally {
            this.loadLatch.countDown();
        }
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        this.plugin.registerFabricListeners();
    }

    private void onServerStarting(MinecraftServer server) {
        this.server = server;
        this.startTime = Instant.now();
        this.plugin.enable();
    }

    private void onServerStopping(MinecraftServer server) {
        this.plugin.disable();
        this.server = null;
    }

    @Override
    public CountDownLatch getLoadLatch() {
        return this.loadLatch;
    }

    @Override
    public CountDownLatch getEnableLatch() {
        return this.enableLatch;
    }

    public Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    public String getVersion() {
        return this.modContainer.getMetadata().getVersion().getFriendlyString();
    }

    @Override
    public Instant getStartupTime() {
        return this.startTime;
    }

    @Override
    public Platform.Type getType() {
        return Platform.Type.FABRIC;
    }

    @Override
    public String getServerBrand() {
        String fabricVersion = FabricLoader.getInstance().getModContainer("fabric").map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
        return "fabric@" + fabricVersion;
    }

    @Override
    public String getServerVersion() {
        String fabricApiVersion = FabricLoader.getInstance().getModContainer("fabric-api-base").map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
        return this.getServer().map(MinecraftServer::method_3827).orElse("null") + " - fabric-api@" + fabricApiVersion;
    }

    @Override
    public Path getDataDirectory() {
        return FabricLoader.getInstance().getGameDir().resolve("mods").resolve(MODID);
    }

    @Override
    public Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir().resolve(MODID);
    }

    @Override
    public InputStream getResourceStream(String path) {
        try {
            return Files.newInputStream(this.modContainer.getPath(path), new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Optional<class_3222> getPlayer(UUID uniqueId) {
        return this.getServer().map(MinecraftServer::method_3760).map(s -> s.method_14602(uniqueId));
    }

    @Override
    public Optional<UUID> lookupUniqueId(String username) {
        return this.getServer().map(s -> s.method_73550().comp_4407()).flatMap(c -> c.method_14515(username)).map(class_11560::comp_4422);
    }

    @Override
    public Optional<String> lookupUsername(UUID uniqueId) {
        return this.getServer().map(s -> s.method_73550().comp_4407()).flatMap(c -> c.method_14512(uniqueId)).map(class_11560::comp_4423);
    }

    @Override
    public int getPlayerCount() {
        return this.getServer().map(MinecraftServer::method_3788).orElse(0);
    }

    @Override
    public Collection<String> getPlayerList() {
        return this.getServer().map(MinecraftServer::method_3760).map(server -> {
            List players = server.method_14571();
            ArrayList<String> list = new ArrayList<String>(players.size());
            for (class_3222 player : players) {
                list.add(player.method_7334().name());
            }
            return list;
        }).orElse(Collections.emptyList());
    }

    @Override
    public Collection<UUID> getOnlinePlayers() {
        return this.getServer().map(MinecraftServer::method_3760).map(server -> {
            List players = server.method_14571();
            ArrayList<UUID> list = new ArrayList<UUID>(players.size());
            for (class_3222 player : players) {
                list.add(player.method_7334().id());
            }
            return list;
        }).orElse(Collections.emptyList());
    }

    @Override
    public boolean isPlayerOnline(UUID uniqueId) {
        return this.getServer().map(MinecraftServer::method_3760).map(s -> s.method_14602(uniqueId) != null).orElse(false);
    }
}

