function sideToVec(side)
	local sides = {
		up    = Vec3( 0, 1, 0),
		down  = Vec3( 0,-1, 0),
		north = Vec3( 0, 0,-1),
		south = Vec3( 0, 0, 1),
		east  = Vec3( 1, 0, 0),
		west  = Vec3(-1, 0, 0),
	}
	
	for k,v in pairs(sides) do
		if k == side then return v; end
	end
	
	log("sideToVec(): Unrecognised side '" .. side .. "', huh?  Returning up")
	return sides.up
end

function stickHandler(event)
	if event.hand ~= "MAIN_HAND" then return true; end
	if not event.player.mainHandItem then return true; end
	if event.player.mainHandItem.name ~= "Stick" then return true; end
	
	print("Sticked")
	print(inspect(event.hitResult, {depth=2}))
	
	local offset = sideToVec(event.hitResult.side)
	spell.pos = event.hitResult.blockPos + offset
	spell.block = Block:new("cobblestone")
	

	return true
end

spell:intercept({"PlayerUseBlockEvent"}, stickHandler)